/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.info;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.info.LimitationByServer;
import com.alrex.parcool.common.network.LimitationByServerMessage;
import net.minecraft.nbt.Tag;

public class ActionInfo {
    private final LimitationByServer serverLimitation = new LimitationByServer();
    private final LimitationByServer individualLimitation = new LimitationByServer();

    public LimitationByServer getIndividualLimitation() {
        return this.individualLimitation;
    }

    public LimitationByServer getServerLimitation() {
        return this.serverLimitation;
    }

    public boolean can(Class<? extends Action> action) {
        return ParCool.isActive() && (Boolean)ParCoolConfig.CONFIG_CLIENT.getPossibilityOf(action).get() != false && this.serverLimitation.isPermitted(action) && this.individualLimitation.isPermitted(action);
    }

    public int getStaminaConsumptionOf(Class<? extends Action> action) {
        int value = (Integer)ParCoolConfig.CONFIG_CLIENT.getStaminaConsumptionOf(action).get();
        value = Math.max(value, this.serverLimitation.getLeastStaminaConsumption(action));
        value = Math.max(value, this.individualLimitation.getLeastStaminaConsumption(action));
        return value;
    }

    public int getMaxStaminaRecoveryLimitation() {
        return Math.min(this.serverLimitation.getMaxStaminaRecovery(), this.individualLimitation.getMaxStaminaRecovery());
    }

    public int getMaxStaminaLimitation() {
        return Math.min(this.serverLimitation.getMaxStaminaLimitation(), this.individualLimitation.getMaxStaminaLimitation());
    }

    public boolean isInfiniteStaminaPermitted() {
        return this.serverLimitation.isInfiniteStaminaPermitted() && this.individualLimitation.isInfiniteStaminaPermitted();
    }

    public void readTag(Tag inbt) {
        this.individualLimitation.readTag(inbt);
    }

    public Tag writeTag() {
        return this.individualLimitation.writeTag();
    }

    public void receiveLimitation(LimitationByServerMessage msg) {
        this.serverLimitation.receive(msg);
    }

    public void receiveIndividualLimitation(LimitationByServerMessage msg) {
        this.individualLimitation.receive(msg);
    }
}

